<!-- livewire/backend/user/modals/privileges.blade.php -->

<div x-data="{
    show: true,
    selectedJobKey: '{{ $selectedUser['settings']['job_title_key'] ?? 'staff' }}',
    jobTitles: {
        manager: { ar: 'مدير', en: 'Manager' },
        supervisor: { ar: 'مشرف', en: 'Supervisor' },
        staff: { ar: 'موظف', en: 'Staff' },
        hr: { ar: 'موظف شؤون الموارد البشرية', en: 'HR Staff' }
    },
    locale: '{{ app()->getLocale() }}',
    assignedPages: @json($selectedUser['pages']['page'] ?? []),
    allPages: ['dashboard', 'users', 'reports', 'settings', 'finance', 'hr_dashboard', 'employee_management'],
    tab: 'assigned',

    availablePages() {
        return this.allPages.filter(p => !this.assignedPages.includes(p));
    },

    togglePage(page) {
        if (this.assignedPages.includes(page)) {
            this.assignedPages = this.assignedPages.filter(p => p !== page);
        } else {
            this.assignedPages.push(page);
        }
    },

    updateJobTitle() {
        $wire.inlineUpdateJobTitle({{ $selectedUser['id'] ?? 'null' }}, this.selectedJobKey);
    },

    savePrivileges() {
        $wire.set('selectedUser.settings.job_title_ar', this.jobTitles[this.selectedJobKey].ar);
        $wire.set('selectedUser.settings.job_title_en', this.jobTitles[this.selectedJobKey].en);
        $wire.set('selectedUser.settings.job_title_key', this.selectedJobKey);
        $wire.set('selectedUser.pages.page', this.assignedPages);
        $wire.updatePrivileges();
    },

    closeModal() {
        this.show = false;
        $wire.closeModal();
    }

}"
x-cloak x-show="show"
x-transition:enter="transition ease-out duration-300"
x-transition:enter-start="opacity-0 scale-90"
x-transition:enter-end="opacity-100 scale-100"
x-transition:leave="transition ease-in duration-200"
x-transition:leave-start="opacity-100 scale-100"
x-transition:leave-end="opacity-0 scale-90"
@keydown.escape.window="closeModal()"
@click.away="closeModal()"
class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 px-4 sm:px-6 lg:px-8">

    <div
        class="bg-white dark:bg-zinc-900 rounded-xl shadow-2xl border border-zinc-200 dark:border-zinc-700 w-full max-w-xl p-6 space-y-6 transition-all duration-300 overflow-y-auto max-h-[90vh]">

        <!-- Header -->
        <div class="flex justify-between items-center">
            <h3 class="text-xl font-bold text-zinc-800 dark:text-white">
                {{ __('backend.user_privileges') }}
            </h3>
            <button @click="closeModal()"
                class="text-zinc-500 hover:text-zinc-800 dark:hover:text-white text-2xl leading-none">
                &times;
            </button>
        </div>

        <!-- Job Titles -->
        <div class="mb-4">
            <label class="block text-sm font-medium text-zinc-700 dark:text-zinc-300 mb-1">
                {{ __('backend.job_titles') }}
            </label>
            <select x-model="selectedJobKey" @change="updateJobTitle()"
                class="w-full px-3 py-2 border rounded text-sm focus:outline-none focus:ring-2 focus:ring-blue-300 bg-blue-100 text-blue-700 dark:bg-gray-700 dark:text-white">
                <template x-for="(job, key) in jobTitles" :key="key">
                    <option :value="key" x-text="job[locale]"></option>
                </template>
            </select>
        </div>

        <!-- Tabs -->
        <div class="mb-4 flex border-b">
            <button @click="tab = 'assigned'"
                :class="tab === 'assigned' ? 'border-b-2 border-blue-500 text-blue-500' : 'text-zinc-600 dark:text-zinc-300'"
                class="px-4 py-2 focus:outline-none transition-colors duration-300">
                {{ __('backend.assigned_pages') }}
            </button>
            <button @click="tab = 'available'"
                :class="tab === 'available' ? 'border-b-2 border-blue-500 text-blue-500' : 'text-zinc-600 dark:text-zinc-300'"
                class="px-4 py-2 focus:outline-none transition-colors duration-300">
                {{ __('backend.available_pages') }}
            </button>
        </div>

        <!-- Pages List -->
        <div>
            <!-- Assigned Pages -->
            <div x-show="tab === 'assigned'" x-transition>
                <template x-for="page in assignedPages" :key="page">
                    <div class="flex items-center space-x-2 py-1">
                        <input type="checkbox" :value="page" checked @change="togglePage(page)"
                            class="form-checkbox h-4 w-4 text-blue-600">
                        <span x-text="page" class="text-sm text-zinc-800 dark:text-white"></span>
                    </div>
                </template>
                <template x-if="assignedPages.length === 0">
                    <p class="text-sm text-zinc-500">{{ __('backend.no_assigned_pages') }}</p>
                </template>
            </div>

            <!-- Available Pages -->
            <div x-show="tab === 'available'" x-transition>
                <template x-for="page in availablePages()" :key="page">
                    <div class="flex items-center space-x-2 py-1">
                        <input type="checkbox" :value="page" @change="togglePage(page)"
                            class="form-checkbox h-4 w-4 text-blue-600">
                        <span x-text="page" class="text-sm text-zinc-800 dark:text-white"></span>
                    </div>
                </template>
                <template x-if="availablePages().length === 0">
                    <p class="text-sm text-zinc-500">{{ __('backend.no_available_pages') }}</p>
                </template>
            </div>
        </div>

        <!-- Footer -->
        <div class="flex justify-end space-x-2 rtl:space-x-reverse">
            <button @click="closeModal()"
                class="px-4 py-2 rounded-lg text-sm bg-zinc-200 dark:bg-zinc-700 hover:bg-zinc-300 dark:hover:bg-zinc-600 text-zinc-800 dark:text-white">
                {{ __('backend.close') }}
            </button>
            <button @click="savePrivileges()"
                class="px-4 py-2 rounded-lg text-sm bg-green-600 text-white hover:bg-green-700">
                {{ __('backend.save') }}
            </button>
        </div>

    </div>
</div>
